<?php
/**
 * Theme functions: init, enqueue scripts and styles, include required files and widgets.
 *
 * @package Case-Themes
 * @since Medicross 1.0
 */

// DEV MODE constants
if (!defined('DEV_MODE')) {
    define('DEV_MODE', true);
}

if (!defined('THEME_DEV_MODE_ELEMENTS') && is_user_logged_in()) {
    define('THEME_DEV_MODE_ELEMENTS', true);
}

// --------------------------------------------------
// Load Theme Textdomain safely
// --------------------------------------------------
function medicross_load_textdomain() {
    load_theme_textdomain('medicross', get_template_directory() . '/languages');
}
add_action('after_setup_theme', 'medicross_load_textdomain');

// --------------------------------------------------
// Include main theme classes and admin initialization
// --------------------------------------------------
require_once get_template_directory() . '/inc/classes/class-main.php';

if (is_admin()) { 
    require_once get_template_directory() . '/inc/admin/admin-init.php'; 
}

// --------------------------------------------------
// Theme required folders
// --------------------------------------------------
if (function_exists('medicross')) {
    medicross()->require_folder('inc');
    medicross()->require_folder('inc/classes');
    medicross()->require_folder('inc/theme-options');
    medicross()->require_folder('template-parts/widgets');

    if (class_exists('WooCommerce')) {
        medicross()->require_folder('woocommerce');
    }
}

// --------------------------------------------------
// Helper: Get image by size
// --------------------------------------------------
if (!function_exists('pxl_get_image_by_size')) {
    function pxl_get_image_by_size($args = []) {
        $args = wp_parse_args($args, [
            'attach_id'  => '',
            'thumb_size' => 'full',
            'class'      => '',
            'use_lazy'   => false,
        ]);

        if (empty($args['attach_id'])) {
            return ['url' => '', 'img' => ''];
        }

        $img_url = wp_get_attachment_image_url($args['attach_id'], $args['thumb_size']);
        $img_tag = wp_get_attachment_image($args['attach_id'], $args['thumb_size'], false, ['class' => esc_attr($args['class'])]);

        return [
            'url' => $img_url,
            'img' => $img_tag
        ];
    }
}
